#!/usr/bin/env python
# Set Plan Bar Color.py
# Copyright 2005 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 050627 - Set the PlanBarColor in the report row

import wx
import re

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

if debug: print 'Start Script'


def SetPlanBarColor(self):

    # set local pointers to tables
    rid = self.ReportID  # current report
    drep = Data.Database['Report']
    drow = Data.Database['ReportRow']
    drt = Data.Database['ReportType']
    rr = drep[rid]

    # make sure report has report type
    if not rr.has_key('ReportTypeID') or not drt.has_key(rr['ReportTypeID']): 
        if debug: print "ReportType key not found"
        hint("Error: Can't find type of this report.")
        return
    rtid = rr['ReportTypeID']

    # is this a task report
    rt = drt[rtid] # pointer to report type record
    ta = rt.get('TableA')
    tb = rt.get('TableB')  # if two table report all inserts go at the end (less confusing to user)
    if not (ta == 'Task' or tb == 'Task'):
        hint('Use script only with Task reports.')
        return

    # find the selected rows
    sel = self.Report.GetSelectedRows()  # current selection
    if len(sel) <= 0:
        hint("Must select at least one task row.")
        return

    rows = self.Report.table.rows
    # get row ids for all task rows
    rids = [ rows[x] for x in sel if drow[rows[x]].get('TableName') == 'Task' ]
    if len(rids) < 1:
        hint("Must select at least one task row.")
        return

#        dbd = Data.Database['Dependency']
#        dids = [ x for x in dbd if dbd[x].get('PrerequisiteID') in tids and dbd[x].get('TaskID') in tids ]

#        for did in dids:  # delete existing dependency records
#            # look for an existing dependency record
#            if Data.Database['Dependency'][did].get('zzStatus') != 'deleted':
#                change = { 'Table': 'Dependency', 'ID': did, 'zzStatus': 'deleted' }
#                Data.Update(change)
#        Data.SetUndo("Remove Dependencies")

    # find old color? (if one row selected)  -- NOT YET
    # oldvalue = Data.Project[rowid].get('Name')
    # if oldvalue == None: oldvalue = ""
    if len(rids) == 1:  # one row selected
        oldvalue = drow[rids[0]].get('PlanBarColor')
        if not oldvalue or not re.match('^[0-9A-F]{6}$', oldvalue):
            oldvalue = ""
    else:
        oldvalue = ""

    # prompt for new color
    dlg = wx.TextEntryDialog(None, 'New plan bar color (six digit hex number, like 8B00FF)', 'Set Plan Bar Color', 'Python')
    dlg.SetValue(oldvalue)
    if dlg.ShowModal() == wx.ID_OK:

        # edit new color
        newcolor = dlg.GetValue()
        newcolor = newcolor.upper()  # set to uppercase hex
        if not (newcolor == "" or re.match('^[0-9A-F]{6}$', newcolor)):
            hint('Color must be six hexidecimal digits.')
            return

        if newcolor == "": newcolor = None

        # change all selected rows to new color
        for rowid in rids:
            if drow[rowid].get('PlanBarColor') != newcolor:
                change = { 'Table': 'ReportRow', 'ID': rowid, 'PlanBarColor': newcolor }
                Data.Update(change)

        Data.SetUndo('Set Plan Bar Color')

    dlg.Destroy()

SetPlanBarColor(self)

if debug: print 'End Script'
